function [shift_energy, shift_g0] = lines_shift(bands, g0, gap_line)

index = zeros(1, size(bands, 2));

for k=1:size(bands, 2)
    temp = find(real(bands(:,k)) > gap_line(k));
    index(k) = temp(1);
end
    
max_index = max(index);
min_index = min(index);
size_shift = size(bands, 1) - (max_index - min_index);

shift_energy = zeros(size_shift, size(bands, 2));
shift_g0 = zeros(size_shift, size(bands, 2));

for i=1:size_shift
    for k=1:size(bands, 2)
        shift_energy(i, k) = bands(i+index(k)-min_index, k);
        shift_g0(i, k) = g0(i+index(k)-min_index, k);
    end
end

end